/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigEventLogNode;
import filenet.vw.toolkit.admin.VWConfigFolderNode;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigRosterNode;
import filenet.vw.toolkit.admin.VWConfigStatusEvent;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class VWConfigBaseNode
extends DefaultMutableTreeNode {
    protected static final ImageIcon unknownIcon32 = VWImageLoader.createImageIcon("unknode32.gif");
    protected static final ImageIcon unknownIcon16 = VWImageLoader.createImageIcon("unknode16.gif");
    public static final int NODE_TYPE_UNKNOWN = 0;
    public static final int NODE_TYPE_WORK_QUEUE = 1;
    public static final int NODE_TYPE_USER_QUEUE = 2;
    public static final int NODE_TYPE_ROSTER = 3;
    public static final int NODE_TYPE_EVENTLOG = 4;
    public static final int NODE_TYPE_COMP_QUEUE = 5;
    public static final int NODE_TYPE_APPSPACE = 6;
    public static final int NODE_TYPE_FOLDER = 16;
    public static final int NODE_TYPE_ROOT = 17;
    public static final int NODE_TYPE_SYSTEM = 18;
    public static final int NODE_TYPE_REGION = 19;
    public static final int NODE_TYPE_WORK_QUEUE_FOLDER = 20;
    public static final int NODE_TYPE_USER_QUEUE_FOLDER = 21;
    public static final int NODE_TYPE_ROSTER_FOLDER = 22;
    public static final int NODE_TYPE_LOG_FOLDER = 23;
    public static final int NODE_TYPE_COMP_QUEUE_FOLDER = 24;
    public static final int NODE_TYPE_APPSPACE_FOLDER = 25;
    public static final int INVALID_REGION_ID = -99;
    public static final int INVALID_SERVERS_ID = -99;
    public static final int ON_ROOT_SERVER = 0;
    public static final int ON_ALL_SERVERS = -1;
    public static final int NO_ORDER = 0;
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = 2;
    public static final int SELECTION_NONE = 0;
    public static final int SELECTION_PARTIAL = 1;
    public static final int SELECTION_ALL = 2;
    private boolean m_dirty = false;
    protected String m_name = null;
    protected ImageIcon m_icon32 = unknownIcon32;
    protected ImageIcon m_icon16 = unknownIcon16;
    protected int m_type = 0;
    protected String m_actionCommand = VWConfigActionCommand.ACMD_UNKNOWN;
    protected String m_serviceName = null;
    protected int m_regionID = -99;
    protected int m_serverID = -99;
    protected VWSessionInfo m_sessionInfo = null;
    protected int m_eventStatus = 0;
    protected int m_workItemsAffected = 0;
    protected String m_description = null;
    protected boolean m_bExportImportSelected = true;
    protected int m_exportOpt = 2;

    public VWConfigBaseNode(String name, ImageIcon icon) {
        super(name);
        this.m_name = name;
        if (icon != null) {
            this.m_icon32 = icon;
        }
    }

    public VWConfigBaseNode(String name, int type, String actionCommand) {
        super(name);
        this.m_name = name;
        this.m_type = type;
        this.m_actionCommand = actionCommand;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getActionCommandString() {
        return this.m_actionCommand;
    }

    public void setActionCommandString(String actionCommand) {
        this.m_actionCommand = actionCommand;
    }

    public Icon getIcon32() {
        return this.m_icon32;
    }

    public void setIcon32(ImageIcon icon) {
        this.m_icon32 = icon;
    }

    public Icon getIcon16() {
        return this.m_icon16;
    }

    public void setIcon16(ImageIcon icon) {
        this.m_icon16 = icon;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setDirty(boolean bPropagate) {
        VWConfigBaseNode aNode;
        this.m_dirty = true;
        if (bPropagate && (aNode = (VWConfigBaseNode)this.getParent()) != null && aNode.getType() != 18) {
            aNode.setDirty(true);
        }
    }

    public void clearDirty(boolean bRecursive) {
        this.m_dirty = false;
        if (bRecursive) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                VWConfigBaseNode bNode = (VWConfigBaseNode)this.getChildAt(i);
                if (bNode == null) continue;
                bNode.clearDirty(true);
            }
        }
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String name) {
        this.m_serviceName = name;
    }

    public int getRegionID() {
        return this.m_regionID;
    }

    public void setRegionID(int id) {
        this.m_regionID = id;
    }

    public String getRegionIDString() {
        if (this.m_regionID >= 0) {
            return Integer.toString(this.m_regionID);
        }
        return "";
    }

    public int getServerID() {
        return this.m_serverID;
    }

    public void setServerID(int id) {
        this.m_serverID = id;
    }

    public String getServerIDString() {
        String svID = "";
        if (this.m_serverID == -1) {
            svID = VWResource.OnAllServers;
        } else if (this.m_serverID != -99) {
            svID = String.valueOf(this.m_serverID);
        }
        return svID;
    }

    public VWSession getSession() {
        if (this.m_sessionInfo != null) {
            return this.m_sessionInfo.getSession();
        }
        return null;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public void setSessionInfo(VWSessionInfo sessionInfo) {
        this.m_sessionInfo = sessionInfo;
    }

    public void fireStatusEvent(int statusType) {
        try {
            VWConfigRootNode root = (VWConfigRootNode)this.findAncestorNode(17);
            VWConfigStatusEvent statusEvt = new VWConfigStatusEvent(root, this, statusType);
            root.fireConfigStatusEvent(statusEvt);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public TreeNode getRoot() {
        VWConfigBaseNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public VWConfigBaseNode findAncestorNode(int type) {
        VWConfigBaseNode bNode = this;
        while (bNode.getType() != type && (bNode = (VWConfigBaseNode)bNode.getParent()) != null) {
        }
        return bNode;
    }

    public void add(VWConfigBaseNode newChild, int type) {
        block9: {
            try {
                int childCount = this.getChildCount();
                String newName = newChild.getName();
                if (childCount == 0) {
                    this.add(newChild);
                    break block9;
                }
                boolean bDone = false;
                String childName = null;
                if (type == 1) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWConfigBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(newName, childName) > 0) continue;
                        this.insert(newChild, i);
                        bDone = true;
                        break;
                    }
                } else if (type == 2) {
                    for (int i = 0; i < childCount; ++i) {
                        childName = ((VWConfigBaseNode)this.getChildAt(i)).getName();
                        if (VWStringUtils.compare(childName, newName) < 0) continue;
                        this.insert(newChild, i);
                        bDone = true;
                        break;
                    }
                }
                if (!bDone) {
                    this.add(newChild);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public void setChangeEventStatus(int status) {
        this.m_eventStatus = status;
    }

    public int getChangeEventStatus() {
        return this.m_eventStatus;
    }

    public int getWorkItemsAffected() {
        return this.m_workItemsAffected;
    }

    public int countWorkItemsAffected() {
        this.m_workItemsAffected = 0;
        return this.m_workItemsAffected;
    }

    public Object clone() {
        VWConfigBaseNode bNode = (VWConfigBaseNode)super.clone();
        bNode.m_name = this.m_name;
        bNode.m_icon32 = this.m_icon32;
        bNode.m_icon16 = this.m_icon16;
        bNode.m_type = this.m_type;
        bNode.m_actionCommand = this.m_actionCommand;
        bNode.m_dirty = this.m_dirty;
        bNode.m_serviceName = this.m_serviceName;
        bNode.m_regionID = this.m_regionID;
        bNode.m_serverID = this.m_serverID;
        bNode.m_sessionInfo = this.m_sessionInfo;
        bNode.m_eventStatus = this.m_eventStatus;
        bNode.m_workItemsAffected = this.m_workItemsAffected;
        bNode.m_exportOpt = this.m_exportOpt;
        bNode.m_description = this.m_description;
        bNode.m_bExportImportSelected = this.m_bExportImportSelected;
        block9: for (int i = 0; i < this.getChildCount(); ++i) {
            VWConfigBaseNode childNode = (VWConfigBaseNode)this.getChildAt(i);
            switch (childNode.getType()) {
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    VWConfigFolderNode folderNode = (VWConfigFolderNode)childNode;
                    bNode.add((VWConfigFolderNode)folderNode.clone());
                    continue block9;
                }
                case 17: {
                    continue block9;
                }
                case 18: {
                    VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)childNode;
                    bNode.add((VWConfigVWServiceNode)sNode.clone());
                    continue block9;
                }
                case 19: {
                    VWConfigRegionNode regionNode = (VWConfigRegionNode)childNode;
                    bNode.add((VWConfigRegionNode)regionNode.clone());
                    continue block9;
                }
                case 1: 
                case 2: 
                case 5: {
                    VWConfigQueueNode queueNode = (VWConfigQueueNode)childNode;
                    bNode.add((VWConfigQueueNode)queueNode.clone());
                    continue block9;
                }
                case 4: {
                    VWConfigEventLogNode logNode = (VWConfigEventLogNode)childNode;
                    bNode.add((VWConfigEventLogNode)logNode.clone());
                    continue block9;
                }
                case 3: {
                    VWConfigRosterNode rosterNode = (VWConfigRosterNode)childNode;
                    bNode.add((VWConfigRosterNode)rosterNode.clone());
                }
            }
        }
        return bNode;
    }

    protected void releaseAllChildrenResources() {
        int childCount = this.getChildCount();
        block9: for (int i = childCount - 1; i >= 0; --i) {
            VWConfigBaseNode childNode = (VWConfigBaseNode)this.getChildAt(i);
            switch (childNode.getType()) {
                case 16: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    ((VWConfigFolderNode)childNode).releaseResources();
                    continue block9;
                }
                case 17: {
                    ((VWConfigRootNode)childNode).releaseResources();
                    continue block9;
                }
                case 18: {
                    ((VWConfigVWServiceNode)childNode).releaseResources();
                    continue block9;
                }
                case 19: {
                    ((VWConfigRegionNode)childNode).releaseResources();
                    continue block9;
                }
                case 1: 
                case 2: 
                case 5: {
                    ((VWConfigQueueNode)childNode).releaseResources();
                    continue block9;
                }
                case 4: {
                    ((VWConfigEventLogNode)childNode).releaseResources();
                    continue block9;
                }
                case 3: {
                    ((VWConfigRosterNode)childNode).releaseResources();
                }
            }
        }
        this.removeAllChildren();
    }

    public void releaseResources() {
        this.releaseAllChildrenResources();
        this.m_sessionInfo = null;
        this.m_name = null;
        this.m_icon32 = null;
        this.m_icon16 = null;
        this.m_actionCommand = null;
        this.m_description = null;
        this.m_serviceName = null;
        this.setUserObject(null);
        this.removeFromParent();
    }

    public boolean isFolderNodeType() {
        return (this.m_type & 0x10) == 16;
    }

    public void setExportSelection(int opt) {
        this.m_exportOpt = opt;
    }

    public int getExportOptSelection() {
        return this.m_exportOpt;
    }

    public void updateExportSelection() {
        if (this.m_exportOpt == 0 || this.m_exportOpt == 1) {
            this.updateExportSelection(2);
        } else {
            this.updateExportSelection(0);
        }
    }

    public void updateExportSelection(int opt) {
        this.m_exportOpt = opt;
        VWConfigBaseNode parentNode = null;
        if (this.m_type != 19) {
            parentNode = (VWConfigBaseNode)this.getParent();
        }
        switch (opt) {
            case 2: {
                if (this.isFolderNodeType()) {
                    int childCount = this.getChildCount();
                    for (int i = childCount - 1; i >= 0; --i) {
                        VWConfigBaseNode childNode = (VWConfigBaseNode)this.getChildAt(i);
                        childNode.updateExportSelection(opt);
                    }
                }
                if (parentNode == null) break;
                if (parentNode.getExportOptSelection() == 0) {
                    parentNode.updateExportSelection(1);
                    break;
                }
                if (parentNode.getExportOptSelection() != 1) break;
                parentNode.validatePartialSelection();
                break;
            }
            case 0: {
                if (this.isFolderNodeType()) {
                    int childCount = this.getChildCount();
                    for (int i = childCount - 1; i >= 0; --i) {
                        VWConfigBaseNode childNode = (VWConfigBaseNode)this.getChildAt(i);
                        childNode.updateExportSelection(opt);
                    }
                }
                if (parentNode == null) break;
                if (parentNode.getExportOptSelection() == 2) {
                    parentNode.updateExportSelection(1);
                    break;
                }
                if (parentNode.getExportOptSelection() != 1) break;
                parentNode.validatePartialSelection();
                break;
            }
            case 1: {
                if (parentNode == null || !parentNode.isFolderNodeType()) break;
                parentNode.updateExportSelection(opt);
            }
        }
    }

    protected void validatePartialSelection() {
        if (this.m_exportOpt != 1) {
            return;
        }
        int childCount = this.getChildCount();
        int selAll = 0;
        int selNone = 0;
        block4: for (int i = childCount - 1; i >= 0; --i) {
            VWConfigBaseNode childNode = (VWConfigBaseNode)this.getChildAt(i);
            switch (childNode.getExportOptSelection()) {
                case 2: {
                    ++selAll;
                    continue block4;
                }
                case 0: {
                    ++selNone;
                }
            }
        }
        if (selAll == childCount) {
            this.m_exportOpt = 2;
        } else if (selAll == 0) {
            this.m_exportOpt = 0;
        }
        if (this.m_type != 19 && this.m_exportOpt != 1) {
            VWConfigBaseNode parentNode = (VWConfigBaseNode)this.getParent();
            parentNode.validatePartialSelection();
        }
    }
}

